/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Id: RS232_Connector.c 13937 2021-02-04 16:10:43Z RMayer $
   Last Modification:
    $Author: RMayer $
    $Date: 2021-02-04 17:10:43 +0100 (Do, 04 Feb 2021) $
    $Revision: 13937 $

   Targets:
     win32    : yes

   Description:
    netXTransport Connector Example (RS232)

   Changes:

     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      2        04.02.21    RM       changed order of free library in RS232_Connector_Deinit()
      1        23.02.13    SD       initial version

**************************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include "netXTransport.h"

static HANDLE           g_hConnectorDll = NULL;
static NETX_CONNECTOR_T s_tRS232Connector;

int32_t RS232_Connector_Init(void)
{
  int32_t   lRet = NXT_NO_ERROR;

  memset( &s_tRS232Connector, 0, sizeof(s_tRS232Connector));

  /* try to load the usb/rs232 - connector */
  if ( NULL == (g_hConnectorDll = LoadLibrary( ".\\Plugins\\RS232Connector.dll")))
  {
    /* Unable to load connector DLL */
    lRet = -1;
  } else
  {
    /* Read the functions from the DLL */
    if ( ((s_tRS232Connector.tFunctions.pfnConGetIdentifier      = ((PFN_NETXCON_GETIDENTIFIER)       GetProcAddress( g_hConnectorDll, "netXConGetIdentifier")))   == NULL) ||
         ((s_tRS232Connector.tFunctions.pfnConOpen               = ((PFN_NETXCON_OPEN)                GetProcAddress( g_hConnectorDll, "netXConOpen")))            == NULL) ||
         ((s_tRS232Connector.tFunctions.pfnConClose              = ((PFN_NETXCON_CLOSE)               GetProcAddress( g_hConnectorDll, "netXConClose")))           == NULL) ||
         ((s_tRS232Connector.tFunctions.pfnConCreateInterface    = ((PFN_NETXCON_CREATEINTERFACE)     GetProcAddress( g_hConnectorDll, "netXConCreateInterface"))) == NULL) ||
         ((s_tRS232Connector.tFunctions.pfnConIntfStart          = ((PFN_NETXCON_INTF_START)          GetProcAddress( g_hConnectorDll, "netXConStartInterface")))  == NULL) ||
         ((s_tRS232Connector.tFunctions.pfnConIntfStop           = ((PFN_NETXCON_INTF_STOP)           GetProcAddress( g_hConnectorDll, "netXConStopInterface")))   == NULL) ||
         ((s_tRS232Connector.tFunctions.pfnConIntfSend           = ((PFN_NETXCON_INTF_SEND)           GetProcAddress( g_hConnectorDll, "netXConSendInterface")))   == NULL) ||
         ((s_tRS232Connector.tFunctions.pfnConIntfGetInformation = ((PFN_NETXCON_INTF_GETINFORMATION) GetProcAddress( g_hConnectorDll, "netXConGetConfig")))       == NULL) )
    {
      lRet = -1;
    } else
    {
      lRet = netXTransportAddConnector(&s_tRS232Connector);
    }
  }
  return lRet;
}

void RS232_Connector_Deinit(void)
{
  if (g_hConnectorDll != NULL)
  {
    /* we are free to remove the registerd connector since the toolkit will do this */
    netXTransportRemoveConnector( &s_tRS232Connector);

    /* unload DLL */
    FreeLibrary( g_hConnectorDll);
  }
}